<?php
require '../db_connection.php';

try {
    $conn = getDBConnection();
    $current_date = date('Y-m-d');
    $stmt = $conn->prepare("SELECT * FROM news WHERE date >= :current_date");
    $stmt->bindParam(':current_date', $current_date, PDO::PARAM_STR);
    $stmt->execute();
    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode(['items' => $result]);
} catch (Exception $e) {
    echo json_encode(['error' => $e->getMessage()]);
}
?>