<?php
require '../db_connection.php';

header('Content-Type: application/json');

if (!isset($_GET['game_id'])) {
    echo json_encode(['error' => 'Missing required parameters']);
    exit;
}

$gameId = $_GET['game_id'];

try {
    $pdo = getDBConnection();

    $stmt = $pdo->prepare("SELECT COUNT(*) as total_reviews, SUM(rating) as total_rating FROM reviews WHERE game_id = :game_id");
    $stmt->execute([':game_id' => $gameId]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    $totalReviews = $row['total_reviews'];
    $totalRating = $row['total_rating'];
    
    if ($totalReviews > 0) {
        $averageRating = round($totalRating / $totalReviews, 2);
    } else {
        $averageRating = 0;
    }

    $updateStmt = $pdo->prepare("UPDATE games SET rating = :rating WHERE id = :game_id");
    $updateStmt->execute([':rating' => $averageRating, ':game_id' => $gameId]);

    $stmt = $pdo->prepare("SELECT rating, review, username FROM reviews WHERE game_id = :game_id");
    $stmt->execute([':game_id' => $gameId]);
    $reviews = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $response = [
        'average_rating' => $averageRating,
        'reviews' => $reviews
    ];

    echo json_encode($response);

} catch (PDOException $e) {
    echo json_encode(['error' => 'Error: ' . $e->getMessage()]);
}
?>