<?php
require '../db_connection.php';

header('Content-Type: application/json');

if (!isset($_GET['game_id'])) {
    echo json_encode(['error' => 'No game_id provided']);
    exit();
}

$game_id = intval($_GET['game_id']);

$conn = getDBConnection();

try {
    $stmt = $conn->prepare("SELECT id, screenshot_url, orientation FROM game_screenshots WHERE game_id = :game_id");
    $stmt->bindParam(':game_id', $game_id, PDO::PARAM_INT);
    $stmt->execute();

    $screenshots = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (!$screenshots) {
        echo json_encode(['error' => 'No screenshots found for this game']);
        exit();
    }

    $base_url = 'https://' . $_SERVER['HTTP_HOST'] . '/pc_launcher/php/uploads/game_screenshots/';
    
    foreach ($screenshots as &$screenshot) {
        $screenshot['screenshot_url'] = $base_url . basename($screenshot['screenshot_url']);
    }

    $json_response = json_encode(['screenshots' => $screenshots]);
    error_log("JSON Response: " . $json_response);
    echo $json_response;

} catch (PDOException $e) {
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
    exit();
}
?>