<?php
session_start();

require '../db_connection.php';

$error_message = '';
$success_message = '';
$two_factor_enabled = false;

$allow_registration = true; // Disable registration of new users
$enable_two_factor_auth = true; // Set to true to enable two-factor authentication

$enable_captcha = false; // Variable to enable/disable hCAPTCHA
// ENTER YOUR SECRET AND SITE KEY IF YOU USE hCAPTCHA
$site_key = "";
$secret = "";

$conn = getDBConnection();

if (isset($_POST['login'])) {
    $username = $_POST['username'];
    $password = $_POST['password'];
    $hcaptcha_response = isset($_POST['h-captcha-response']) ? $_POST['h-captcha-response'] : null;

    if ($enable_captcha && $hcaptcha_response) {
        $response = file_get_contents("https://hcaptcha.com/siteverify?secret={$secret}&response={$hcaptcha_response}");
        $response_keys = json_decode($response, true);

        if (!$response_keys["success"]) {
            $error_message = "Please complete the CAPTCHA.";
        }
    }

    if (!$enable_captcha || empty($error_message)) {
        if (!empty($username) && !empty($password)) {
            try {
                $stmt = $conn->prepare("SELECT * FROM developers WHERE username = :username OR email = :username");
                $stmt->bindParam(':username', $username, PDO::PARAM_STR);
                $stmt->execute();
                $developer = $stmt->fetch(PDO::FETCH_ASSOC);
                
                if ($developer) {
                    if (password_verify($password, $developer['password'])) {
                        if ($enable_two_factor_auth) {
                            function generateTwoFactorCode($length = 6) {
                                $characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
                                $code = '';
                                for ($i = 0; $i < $length; $i++) {
                                    $code .= $characters[rand(0, strlen($characters) - 1)];
                                }
                                return $code;
                            }

                            $two_factor_code = generateTwoFactorCode(6);
                            $_SESSION['two_factor_code'] = $two_factor_code;
                            $_SESSION['developer_id'] = $developer['id'];

                            $to = $developer['email'];
                            $subject = 'Developer Login Verification Code';
                            $verificationCode = $two_factor_code;
                            $message = "
                            <html lang='en'>
                            <head>
                                <meta charset='UTF-8'>
                                <title>Developer Login Verification Code</title>
                                <link href='https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap' rel='stylesheet'>
                            </head>
                            <body style='width: 100%; max-width: 600px; margin: 0 auto; padding: 0; display: flex; justify-content: center; align-items: center; background-color: #f4f4f9; color: #333333; font-family: \"Roboto\", sans-serif; line-height: 1.6; -webkit-text-size-adjust: none;'>
                                <div class='container' style='width: 100%; max-width: 600px; margin: 20px auto; padding: 40px 20px; border-radius: 10px; background: linear-gradient(135deg, #ffffff, #e0f7fa); box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15); text-align: center;'>
                                    <div class='logo'>
                                        <img src='https://drive.google.com/uc?id=16kOxTUBeHjYSyoJYL7AzXJyGU7UqtXPg' alt='Logo' style='width: 100px; height: auto;'>
                                    </div>
                                    <h2 style='color: #2c3e50; font-size: 28px; margin-bottom: 20px; font-weight: 700;'>DEVELOPER LOGIN VERIFICATION CODE</h2>
                                    <hr style='background-color: #3490EC; height: 2px; border: none; margin: 20px 0;'>
                                    <div class='verification-code' style='font-size: 40px; color: #3490EC; border: 2px solid #3490EC; padding: 20px 40px; border-radius: 60px; display: inline-block; animation: blink 1.5s infinite; margin: 20px 0; background-color: rgba(52, 144, 236, 0.1);'>$verificationCode</div>
                                    <p class='code-instructions' style='font-size: 16px; margin: 40px 0; color: #555555; font-style: italic;'>Your login code is <span class='highlight' style='color: #3490EC; font-weight: 700; font-size: 18px;'>$verificationCode</span>. Please enter this code to access your developer account.<br> DO NOT SHARE THIS CODE WITH ANYONE!</p>
                                    <p class='code-instructions' style='font-size: 16px; margin: 40px 0; color: #555555; font-style: italic;'>If you did not request this code, please ignore this message.</p>
                                    <div class='decorative-element' style='width: 80%; height: 4px; background: #3490EC; margin: 20px auto; border-radius: 10px; box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);'></div>
                                    <div class='footer' style='font-size: 14px; color: #777777; margin-top: 40px; border-top: 1px solid #ddd; padding-top: 20px; position: relative;'>
                                        AisenCorporation © 2024<br>
                                        <strong style='display: block; margin-bottom: 5px;'>Secure Login Code</strong>
                                        AILauncher
                                    </div>
                                </div>
                            </body>
                            </html>";                        

                            $headers = "From: no-reply@aisencorporation.com\r\n";
                            $headers .= "Content-type: text/html; charset=UTF-8\r\n";

                            if(mail($to, $subject, $message, $headers)) {
                                $two_factor_enabled = true;
                            } else {
                                $error_message = 'Error confirming code, please make sure you are entering the correct code.';
                            }
                    } else {
                        $_SESSION['developer_id'] = $developer['id'];
                        header("Location: dashboard.php");
                        exit();
                    }
                } else {
                    $error_message = "Incorrect password.";
                }
            } else {
                $error_message = "User is not found.";
            }
            } catch (PDOException $e) {
                $error_message = 'Database Error: ' . $e->getMessage();
            }
        } else {
            $error_message = "Fill in all the fields.";
        }
    }
}

if (isset($_POST['verify'])) {
    $input_code = $_POST['two_factor_code'];

    if ($input_code == $_SESSION['two_factor_code']) {
        header("Location: dashboard.php");
        exit();
    } else {
        $error_message = "Incorrect code.";
    }
}

if ($allow_registration && isset($_POST['register'])) {
    $username = $_POST['reg_username'];
    $companyname = $_POST['reg_companyname'];
    $email = $_POST['reg_email'];
    $password = $_POST['reg_password'];
    $confirm_password = $_POST['reg_confirm_password'];

    if (!empty($username) && !empty($companyname) && !empty($email) && !empty($password) && !empty($confirm_password)) {
        if ($password === $confirm_password) {
            try {
                $stmt = $conn->prepare("SELECT * FROM developers WHERE username = :username OR email = :email OR companyname = :companyname");
                $stmt->bindParam(':username', $username, PDO::PARAM_STR);
                $stmt->bindParam(':email', $email, PDO::PARAM_STR);
                $stmt->bindParam(':companyname', $companyname, PDO::PARAM_STR);
                $stmt->execute();
                $existingDeveloper = $stmt->fetch(PDO::FETCH_ASSOC);

                if ($existingDeveloper) {
                    if ($existingDeveloper['username'] == $username) {
                        $error_message = "Username already exists.";
                    } elseif ($existingDeveloper['email'] == $email) {
                        $error_message = "User with this email already exists.";
                    } elseif ($existingDeveloper['companyname'] == $companyname) {
                        $error_message = "Company with this name already exists.";
                    }
                } else {
                    $hashed_password = password_hash($password, PASSWORD_BCRYPT);
                    $stmt = $conn->prepare("INSERT INTO developers (username, companyname, email, password) VALUES (:username, :companyname, :email, :password)");
                    $stmt->bindParam(':username', $username, PDO::PARAM_STR);
                    $stmt->bindParam(':companyname', $companyname, PDO::PARAM_STR);
                    $stmt->bindParam(':email', $email, PDO::PARAM_STR);
                    $stmt->bindParam(':password', $hashed_password, PDO::PARAM_STR);
                    $stmt->execute();
                    $success_message = "You have successfully registered.";
                }
            } catch (PDOException $e) {
                $error_message = 'Database Error: ' . $e->getMessage();
            }
        } else {
            $error_message = "Passwords do not match.";
        }
    } else {
        $error_message = "Please fill in all fields.";
    }
}

if (isset($_POST['forgot_password'])) {
    $email = $_POST['email'];
    
    if (!empty($email)) {
        try {
            $stmt = $conn->prepare("SELECT * FROM developers WHERE email = :email");
            $stmt->bindParam(':email', $email, PDO::PARAM_STR);
            $stmt->execute();
            $developer = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($developer) {
                function generateResetToken($length = 50) {
                    return bin2hex(random_bytes($length));
                }

                $reset_token = generateResetToken();
                $_SESSION['reset_token'] = $reset_token;
                $_SESSION['developer_id'] = $developer['id'];
                
                $domain = $_SERVER['HTTP_HOST'];
                $reset_link = "https://$domain/pc_launcher/php/developer_console/reset_password.php?token=$reset_token";

                $to = $developer['email'];
                $subject = 'Password Reset Request';
                $message = "
                <html lang='en'>
                <head>
                    <meta charset='UTF-8'>
                    <title>Password Reset Request</title>
                    <link href='https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap' rel='stylesheet'>
                </head>
                <body style='width: 100%; max-width: 600px; margin: 0 auto; padding: 0; display: flex; justify-content: center; align-items: center; background-color: #f4f4f9; color: #333333; font-family: \"Roboto\", sans-serif; line-height: 1.6; -webkit-text-size-adjust: none;'>
                    <div class='container' style='width: 100%; max-width: 600px; margin: 20px auto; padding: 40px 20px; border-radius: 10px; background: linear-gradient(135deg, #ffffff, #e0f7fa); box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15); text-align: center;'>
                        <div class='logo'>
                            <img src='https://drive.google.com/uc?id=16kOxTUBeHjYSyoJYL7AzXJyGU7UqtXPg' alt='Logo' style='width: 100px; height: auto;'>
                        </div>
                        <h2 style='color: #2c3e50; font-size: 28px; margin-bottom: 20px; font-weight: 700;'>PASSWORD RESET REQUEST</h2>
                        <hr style='background-color: #3490EC; height: 2px; border: none; margin: 20px 0;'>
                        <a class='reset-link' href='$reset_link' style='font-size: 18px; color: #3490EC; text-decoration: none; padding: 10px 20px; border: 2px solid #3490EC; border-radius: 10px; display: inline-block; margin: 20px 0; background-color: rgba(52, 144, 236, 0.1);'>Click here to reset your password</a>
                        <p style='margin: 20px 0;'>If you did not request this password reset, please ignore this email.</p>
                        <div class='decorative-element' style='width: 80%; height: 4px; background: #3490EC; margin: 20px auto; border-radius: 10px; box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);'></div>
                        <div class='footer' style='font-size: 14px; color: #777777; margin-top: 40px; border-top: 1px solid #ddd; padding-top: 20px; position: relative;'>
                            AisenCorporation © 2024<br>
                            <strong style='display: block; margin-bottom: 5px;'>Secure Password Reset</strong>
                            AILauncher
                        </div>
                    </div>
                </body>
                </html>";                

                $headers = "From: no-reply@aisencorporation.com\r\n";
                $headers .= "Content-type: text/html; charset=UTF-8\r\n";

                if(mail($to, $subject, $message, $headers)) {
                    $success_message = 'Password reset link sent to your email.';
                } else {
                    $error_message = 'Error sending password reset email.';
                }
            } else {
                $error_message = 'Email not found.';
            }
        } catch (PDOException $e) {
            $error_message = 'Database Error: ' . $e->getMessage();
        }
    } else {
        $error_message = "Enter your email.";
    }
}

$conn = null;
?>

<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Developer Login Page</title>
    <link rel="shortcut icon" href="https://aisencorporation.com/icons/ais_corp.png" type="image/x-icon">
    <link rel="stylesheet" href="styles/index.css">
    <script src="main.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
</head>
<body>
    <div class="container">
        <h2 id="dynamic-header">Developer Login</h2>
        
        <?php if ($error_message): ?>
            <div class="message"><?php echo $error_message; ?></div>
        <?php endif; ?>

        <?php if ($success_message): ?>
            <div class="message success"><?php echo $success_message; ?></div>
        <?php endif; ?>

        <?php if ($two_factor_enabled && $enable_two_factor_auth): ?>
            <form id="verify-form" method="POST" action="">
                <input type="text" name="two_factor_code" placeholder="Enter the code sent to the developer's email" required>
                <input type="submit" name="verify" value="Confirm and login">
            </form>
        <?php else: ?>
            <form id="login-form" method="POST" action="">
            <input type="text" name="username" placeholder="Username or email" required>
            <input type="password" name="password" placeholder="Password" required>
            <?php if ($enable_captcha): ?>
                <div class="h-captcha" data-sitekey="<?php echo $site_key; ?>"></div>
            <?php endif; ?>
            <input type="submit" name="login" value="Login">
        </form>
        <?php if ($enable_captcha): ?>
            <script src="https://js.hcaptcha.com/1/api.js" async defer></script>
        <?php endif; ?>

            <br><span class="toggle-button forgot-password" id="forgot-password-link">Forgot Password?</span>

            <form id="forgot-password-form" method="POST" action="" class="hidden">
                <input type="email" name="email" placeholder="Enter your email" required>
                <input type="submit" name="forgot_password" value="Reset Password">
            </form>
        <?php endif; ?>

        <?php if ($allow_registration): ?>
            <form id="register-form" method="POST" action="" class="hidden">
                <input type="text" name="reg_username" placeholder="Username" required>
                <input type="text" name="reg_companyname" placeholder="Company Name" required>
                <input type="email" name="reg_email" placeholder="Email" required>
                <div class="password-container">
                    <input type="password" id="reg_password" name="reg_password" placeholder="Password">
                    <input type="password" name="reg_confirm_password" placeholder="Confirm Password" required>
                </div>
                <input type="submit" name="register" value="Register">
            </form>
            <div id="register-button" class="toggle-button">No account yet? Register here.</div>
        <?php endif; ?>
        <div id="login-button" class="toggle-button hidden">I have an account. Login here.</div>
    </div>

    <script>
        const dynamicHeader = document.getElementById('dynamic-header');
        const registerButton = document.getElementById('register-button');
        const loginButton = document.getElementById('login-button');
        const loginForm = document.getElementById('login-form');
        const registerForm = document.getElementById('register-form');
        const registerHeader = document.getElementById('register-header');
        const forgotPasswordLink = document.getElementById('forgot-password-link');
        const forgotPasswordForm = document.getElementById('forgot-password-form');

        function updateHeader(headerText) {
            dynamicHeader.textContent = headerText;
        }

        registerButton.addEventListener('click', () => {
            loginForm.classList.add('hidden');
            registerForm.classList.remove('hidden');
            registerButton.classList.add('hidden');
            loginButton.classList.remove('hidden');
            forgotPasswordForm.classList.add('hidden');
            forgotPasswordLink.classList.add('hidden');
            updateHeader('Registration');
            
            document.body.style.setProperty('--background-image', 'url("https://aisencorporation.com/icons/user_registration.jpg")');
        });

        loginButton.addEventListener('click', () => {
            loginForm.classList.remove('hidden');
            registerForm.classList.add('hidden');
            registerButton.classList.remove('hidden');
            loginButton.classList.add('hidden');
            forgotPasswordLink.classList.remove('hidden');
            updateHeader('Developer Login');
            
            document.body.style.setProperty('--background-image', 'url("https://aisencorporation.com/icons/user_login.jpg")');
        });

        forgotPasswordLink.addEventListener('click', () => {
            forgotPasswordForm.classList.remove('hidden');
            loginForm.classList.add('hidden');
            forgotPasswordLink.classList.add('hidden');
            registerButton.classList.add('hidden');
            updateHeader('Forgot Password');

            document.body.style.setProperty('--background-image', 'url("https://aisencorporation.com/icons/user_login.jpg")');
        });
    </script>
</body>
</html>