<?php
session_start();

require '../db_connection.php';

$error_message = '';
$success_message = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_FILES['installer_file']) && isset($_POST['version']) && isset($_POST['release_notes'])) {
        $version = trim($_POST['version']);
        $release_notes = trim($_POST['release_notes']);
        $uploadOk = 1;
        $uploadDir = '../uploads/game_uploads/';
        
        $installerFile = $uploadDir . basename($_FILES['installer_file']['name']);
        $fileType = strtolower(pathinfo($installerFile, PATHINFO_EXTENSION));

        if ($fileType != 'zip') {
            $error_message = "Sorry, only ZIP files are allowed.";
            $uploadOk = 0;
        }

        if ($_FILES['installer_file']['error'] !== UPLOAD_ERR_OK) {
            $error_message = "An error occurred while loading the file: " . $_FILES['installer_file']['error'];
            $uploadOk = 0;
        }

        if ($uploadOk == 1) {
            $conn->begin_transaction(); 
            try {
                if (file_exists($installerFile)) {
                    if (!unlink($installerFile)) {
                        $error_message = "Sorry, could not delete existing file.";
                    }
                }

                if (!move_uploaded_file($_FILES['installer_file']['tmp_name'], $installerFile)) {
                    $error_message = "Sorry, there was an error loading the file.";
                }

                $installerFile = $conn->real_escape_string($installerFile);
                $version = $conn->real_escape_string($version);
                $release_notes = $conn->real_escape_string($release_notes);

                $check_sql = "SELECT id FROM app_updates WHERE version = '$version'";
                $result = $conn->query($check_sql);

                if ($result->num_rows > 0) {
                    $update_sql = "UPDATE app_updates SET installer_url = '$installerFile', release_notes = '$release_notes', upload_date = NOW() WHERE version = '$version'";
                    if (!$conn->query($update_sql)) {
                        $error_message = "Error updating information in the database: " . $conn->error;
                    }
                } else {
                    $insert_sql = "INSERT INTO app_updates (version, installer_url, release_notes, upload_date) VALUES ('$version', '$installerFile', '$release_notes', NOW())";
                    if (!$conn->query($insert_sql)) {
                        $error_message = "Error saving information to the database: " . $conn->error;
                    }
                }

                $conn->commit();
                $success_message = "File and version information uploaded successfully.";
            } catch (Exception $e) {
                $conn->rollback();
                $error_message = $e->getMessage();
            }
        }
    } else {
        $error_message = "Please provide the ZIP file, version and release notes.";
    }
}
?>

<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Update Launcher - Developer Console</title>
    <link rel="shortcut icon" href="https://aisencorporation.com/icons/ais_corp.png" type="image/x-icon">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="styles/dashboard.css">
</head>
<body>
    <div class="container">
        <button class="button" onclick="window.location.href = 'dashboard.php'" style="float: left;">
            <div class="button-box">
                <span class="button-elem">
                    <svg viewBox="0 0 46 40" xmlns="http://www.w3.org/2000/svg">
                        <path d="M46 20.038c0-.7-.3-1.5-.8-2.1l-16-17c-1.1-1-3.2-1.4-4.4-.3-1.2 1.1-1.2 3.3 0 4.4l11.3 11.9H3c-1.7 0-3 1.3-3 3s1.3 3 3 3h33.1l-11.3 11.9c-1 1-1.2 3.3 0 4.4 1.2 1.1 3.3.8 4.4-.3l16-17c.5-.5.8-1.1.8-1.9z"></path>
                    </svg>
                </span>
            </div>
        </button><br>

        <br><h1>Uploading a new version of the application</h1>

        <?php if ($error_message): ?>
            <div class="message error">
                <span class="close-button" onclick="this.parentElement.style.display='none'">&times;</span>
                <?php echo $error_message; ?>
            </div>
        <?php endif; ?>
        <?php if ($success_message): ?>
            <div class="message success">
                <span class="close-button" onclick="this.parentElement.style.display='none'">&times;</span>
                <?php echo $success_message; ?>
            </div>
        <?php endif; ?>

        <form id="uploadForm" action="" method="post" enctype="multipart/form-data">
            <label for="version">New version of launcher:</label>
            <input type="text" id="version" name="version" required>

            <label for="release_notes">Release Notes:</label>
            <textarea name="release_notes" required></textarea>

            <label for="installer_file">Installer File:</label>
            <input type="file" id="installer_file" name="installer_file" accept=".zip" required><br>

            <button type="submit" class="upload-game">Upload Launcher</button>
        </form>
    </div>

    <div id="progressWrapper">
        <h2>Uploading...</h2>
        <progress id="progressBar" value="0" max="100"></progress>
        <span id="progressPercent">0%</span>
        <div class="progress-info">
            <span id="uploadedSize">0 MB</span> / <span id="totalSize">0 MB</span><br>
            <span id="uploadSpeed">Speed: 0 KB/s</span><br>
            <span id="remainingTime">Estimated Time Remaining: N/A</span>
        </div>
    </div>

    <script>
        document.getElementById('uploadForm').addEventListener('submit', function(event) {
            event.preventDefault();
            var form = event.target;
            var formData = new FormData(form);

            var progressWrapper = document.getElementById('progressWrapper');
            var progressBar = document.getElementById('progressBar');
            var progressPercent = document.getElementById('progressPercent');
            var uploadedSize = document.getElementById('uploadedSize');
            var totalSize = document.getElementById('totalSize');
            var uploadSpeed = document.getElementById('uploadSpeed');
            var remainingTime = document.getElementById('remainingTime');

            progressWrapper.style.display = 'flex';

            var xhr = new XMLHttpRequest();
            xhr.open('POST', form.action, true);

            var fileSize = formData.get('installer_file').size;
            totalSize.textContent = (fileSize / 1024 / 1024).toFixed(2) + ' MB';

            var startTime = Date.now();
            var previousTime = startTime;
            var previousLoaded = 0;

            xhr.upload.addEventListener('progress', function(e) {
                if (e.lengthComputable) {
                    var percentComplete = (e.loaded / e.total) * 100;
                    progressBar.value = percentComplete;
                    progressPercent.textContent = Math.round(percentComplete) + '%';

                    var currentTime = Date.now();
                    var elapsedTime = (currentTime - previousTime) / 1000; 
                    var loadedDiff = e.loaded - previousLoaded;

                    if (elapsedTime > 0) {
                        var speed = (loadedDiff / elapsedTime) / 1024;
                        uploadSpeed.textContent = 'Speed: ' + speed.toFixed(2) + ' KB/s';
                    }

                    var remaining = (fileSize - e.loaded) / (e.loaded / ((currentTime - startTime) / 1000));
                    remainingTime.textContent = 'Estimated Time Remaining: ' + (remaining > 0 ? remaining.toFixed(0) + ' seconds' : 'N/A');

                    uploadedSize.textContent = (e.loaded / 1024 / 1024).toFixed(2) + ' MB';

                    previousLoaded = e.loaded;
                    previousTime = currentTime;
                }
            });

            xhr.onload = function() {
                if (xhr.status === 200) {
                    alert('Upload complete!');
                    progressWrapper.style.display = 'none';
                    form.reset();
                } else {
                    console.error('Server error:', xhr.status, xhr.statusText);
                    alert('An error occurred while uploading the file.');
                }
            };

            xhr.onerror = function() {
                alert('An error occurred during the upload.');
            };

            xhr.send(formData);
        });
    </script>
</body>
</html>