// -----------------
// Dashboard Script Block
// Initializing script loading
// -----------------
document.addEventListener('DOMContentLoaded', function () {
    restoreScrollPosition();
    initialize();
});

const developer_id = '<?php echo $developer_id; ?>';
let screenshotsFiles = [];
let uploadedChunks = 0;

// -----------------
// Loading core functions
// -----------------
function initialize() {
    const successMessage = document.querySelector('.message.success');
    const errorMessage = document.querySelector('.message.error');
    const closeButtons = document.querySelectorAll('.close-button');

    const showMessage = (message) => {
        message.classList.add('show');

        setTimeout(() => {
            message.classList.remove('show');
        }, 5000);
    };

    if (successMessage) {
        showMessage(successMessage);
    }
    if (errorMessage) {
        showMessage(errorMessage);
    }

    closeButtons.forEach(button => {
        button.addEventListener('click', (event) => {
            const message = event.target.closest('.message');
            message.classList.remove('show');
        });
    });
    
    initializeTags();

    const gameSelect = document.getElementById('game_id');
    updateGameInfo(gameSelect);

    gameSelect.addEventListener('change', enableSubmitButton);
    document.querySelector('form').addEventListener('submit', disableSubmitButton);

    document.getElementById('game_avatar').addEventListener('change', handleAvatarChange);
    document.getElementById('game_screenshots').addEventListener('change', handleScreenshotsChange);
    document.getElementById('avatarInput').addEventListener('change', handleAvatarChange);
}

function saveScrollPosition() {
    sessionStorage.setItem('scrollPosition', window.scrollY);
}

function restoreScrollPosition() {
    const scrollPosition = sessionStorage.getItem('scrollPosition');
    if (scrollPosition) {
        window.scrollTo(0, parseInt(scrollPosition, 10));
    }
}

function handleAvatarChange() {
    document.getElementById('avatarUploadForm').submit();
}

function toggleAvatarForm() {
    var form = document.getElementById('avatarForm');
    form.style.display = (form.style.display === 'none') ? 'block' : 'none';
}

function toggleUsernameInput() {
    const usernameDiv = document.getElementById('username-change');
    usernameDiv.style.display = usernameDiv.style.display === 'none' ? 'block' : 'none';
}

document.getElementById("toggleManualUpload").addEventListener("click", function(event) {
    toggleVisibility(event, 'manualUpload');
    saveScrollPosition();
});

function toggleVisibility(event, elementId) {
    const element = document.getElementById(elementId);
    element.classList.toggle("hidden");

    restoreScrollPosition();
}

function changeUsername() {
    const newUsername = document.getElementById('new_username').value;
    if (newUsername) {
        const formData = new FormData();
        formData.append('change_username', true);
        formData.append('new_username', newUsername);

        fetch('', {
            method: 'POST',
            body: formData
        }).then(response => response.text()).then(data => {
            location.reload();
        });
    } else {
        alert('Please enter a new username.');
    }
}

function updateGameInfo(selectElement) {
    var selectedOption = selectElement.options[selectElement.selectedIndex];
    var avatar = selectedOption.getAttribute('data-avatar');
    var description = selectedOption.getAttribute('data-description');

    var avatarImg = document.getElementById('game_avatar');
    var descriptionP = document.getElementById('game_description');

    if (selectedOption.value) {
        avatarImg.src = avatar;
        avatarImg.style.display = 'block';
        descriptionP.innerHTML = "<strong>Description:</strong> " + description;
    } else {
        avatarImg.style.display = 'none';
        descriptionP.innerHTML = "";
    }
}

function enableSubmitButton() {
    document.getElementById('submitBtn').disabled = false;
}

function disableSubmitButton() {
    document.getElementById('submitBtn').disabled = true;
}

function handleAvatarChange(event) {
    const file = event.target.files[0];
    const avatarPreview = document.getElementById('avatar_preview');
    avatarPreview.innerHTML = '';

    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            avatarPreview.innerHTML = `
                <div class="preview-image">
                    <img src="${e.target.result}" alt="Avatar Preview" onclick="openModal('${e.target.result}')" />
                    <button class="remove-button" onclick="removeAvatar()">✖</button>
                </div>
            `;
        };
        reader.readAsDataURL(file);
    }
}

function removeAvatar() {
    const avatarInput = document.getElementById('game_avatar');
        
    const dataTransfer = new DataTransfer();
    avatarInput.files = dataTransfer.files;

    document.getElementById('avatar_preview').innerHTML = '';
}

function handleScreenshotsChange() {
    const files = Array.from(this.files);
    const screenshotsPreview = document.getElementById('screenshots_preview');
    screenshotsPreview.innerHTML = '';
    screenshotsFiles = files;

    files.forEach((file, index) => {
        const reader = new FileReader();
        reader.onload = function(e) {
            screenshotsPreview.innerHTML += `
                <div class="preview-image" data-index="${index}">
                    <img src="${e.target.result}" alt="Screenshot Preview" onclick="openModal('${e.target.result}')" style="cursor: pointer;" />
                    <button class="remove-button" onclick="removeScreenshot(${index})">✖</button>
                </div>
            `;
        };
        reader.readAsDataURL(file);
    });
}

function removeScreenshot(index) {
    screenshotsFiles.splice(index, 1);

    const screenshotsPreview = document.getElementById('screenshots_preview');
    screenshotsPreview.innerHTML = '';

    screenshotsFiles.forEach((file, newIndex) => {
        const reader = new FileReader();
        reader.onload = function(e) {
            screenshotsPreview.innerHTML += `
                <div class="preview-image" data-index="${newIndex}">
                    <img src="${e.target.result}" alt="Screenshot Preview" onclick="openModal('${e.target.result}')" style="cursor: pointer;" />
                    <button class="remove-button" onclick="removeScreenshot(${newIndex})">✖</button>
                </div>
            `;
        };
        reader.readAsDataURL(file);
    });

    saveScrollPosition();

    const dataTransfer = new DataTransfer();
    screenshotsFiles.forEach(file => dataTransfer.items.add(file));
    document.getElementById('game_screenshots').files = dataTransfer.files;
}

function previewImage(event) {
    const previewImage = document.getElementById('bannerPreview');
    const file = event.target.files[0];
    if (file && file.type.startsWith('image/')) {
        const reader = new FileReader();
        reader.onload = (e) => {
            previewImage.src = e.target.result;
            previewImage.style.display = 'block';
            document.querySelector('.dropzone span').style.display = 'none';
        };
        reader.readAsDataURL(file);
    }
}

function openModal(imageSrc) {
    const modal = document.getElementById('modal');
    const modalImage = document.getElementById('modalImage');
    modalImage.src = imageSrc;
    modal.style.display = 'flex';
}

function toggleGameDay() {
    const gameDayBlock = document.getElementById('gameDayBlock');

    saveScrollPosition();

    if (gameDayBlock.style.display === "none") {
        gameDayBlock.style.display = "block";
    } else {
        gameDayBlock.style.display = "none";
    }
    restoreScrollPosition();
}

function initializeTags() {
    let availableTags = [];
    let selectedTags = [];
    const inputField = document.getElementById('game_tags_input');
    const selectedTagsDiv = document.getElementById('selected-tags');
    const errorMessage = document.getElementById('error-message');
    const hiddenField = document.getElementById('game_tags_hidden');

    fetch('../data_fetchers/get_tags.php')
        .then(response => response.json())
        .then(data => {
            availableTags = data;
            const datalist = document.getElementById('tagsList');
            availableTags.forEach(function(tag) {
                const option = document.createElement('option');
                option.value = tag;
                datalist.appendChild(option);
            });
        })
        .catch(error => console.error('Error fetching tags:', error));

    inputField.addEventListener('change', function() {
        const newTag = inputField.value;

        if (availableTags.includes(newTag) && !selectedTags.includes(newTag) && selectedTags.length < 5) {
            selectedTags.push(newTag);

            const tagElement = document.createElement('span');
            tagElement.className = 'tag';
            tagElement.innerHTML = newTag + ' <button type="button" class="remove-tag">&times;</button>';
            selectedTagsDiv.appendChild(tagElement);

            inputField.value = '';
            errorMessage.textContent = '';

            tagElement.querySelector('.remove-tag').addEventListener('click', function() {
                selectedTagsDiv.removeChild(tagElement);
                selectedTags = selectedTags.filter(tag => tag !== newTag);
                updateHiddenField();
            });

            updateHiddenField();
        } else if (!availableTags.includes(newTag)) {
            errorMessage.textContent = 'This tag is not available for selection.';
        } else if (selectedTags.includes(newTag)) {
            errorMessage.textContent = 'This tag has already been selected.';
        } else if (selectedTags.length >= 5) {
            errorMessage.textContent = 'You cannot add more than 5 tags.';
        }
    });

    function updateHiddenField() {
        hiddenField.value = selectedTags.join(',');
    }
}

function LoadNewGame() {
    const uploadForm = document.querySelector('#uploadForm');
    const executableUploadForm = document.querySelector('#executableUploadForm');
                
    saveScrollPosition();

    if (uploadForm.classList.contains('hidden')) {
        uploadForm.classList.remove('hidden');
        uploadForm.classList.add('visible');
        executableUploadForm.classList.add('hidden');
    } else {
        uploadForm.classList.remove('hidden');
        uploadForm.classList.add('hidden');
        executableUploadForm.classList.remove('hidden');
        executableUploadForm.classList.add('hidden');
    }      
    restoreScrollPosition();
}

function uploadMetadata() {
    const formData = new FormData(document.getElementById('uploadForm'));

    const fields = document.querySelectorAll('#uploadForm input, #uploadForm textarea');
    fields.forEach(field => {
        field.disabled = true;
    });

    const submitButton = document.querySelector('#uploadForm .upload-game');
    if (submitButton) {
        submitButton.disabled = true;
        submitButton.style.cursor = 'not-allowed';
    }

    showLoader();
    updateProgressText('Creating draft. Loading game data...');

    fetch('upload_metadata.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        hideLoader();
        if (data.status === 'success') {
            alert('Game data uploaded successfully. Now upload the game zip archive.');
            document.getElementById('executableUploadForm').classList.remove('hidden');
            document.getElementById('game_executable_path').value = data.game_id;
        } else {
            console.error('error', 'Error uploading game data: ' + data.message);
        }
    })
    .catch(error => {
        hideLoader();
        console.error('Error:', error);
    });
}

function startUpload(gameId, inputId) {
    const fileInput = document.getElementById(inputId);
    if (fileInput.files.length === 0) {
        alert('Please select a ZIP file to upload.');
        return;
    }

    const file = fileInput.files[0];
    const chunkSize = 5 * 1024 * 1024;
    const totalChunks = Math.ceil(file.size / chunkSize);
    let currentChunk = 0;

    showLoader();

    const startTime = new Date();

    function uploadChunk(chunkNumber) {
        const start = chunkNumber * chunkSize;
        const end = Math.min(start + chunkSize, file.size);
        const chunk = file.slice(start, end);

        const formData = new FormData();
        formData.append('chunk', chunk);
        formData.append('chunk_number', chunkNumber);
        formData.append('total_chunks', totalChunks);
        formData.append('game_id', gameId);

        const xhr = new XMLHttpRequest();
        xhr.open('POST', 'upload_chunk.php', true);

        xhr.upload.onprogress = function(event) {
            if (event.lengthComputable) {
                const loaded = chunkNumber * chunkSize + event.loaded;
                const percentComplete = ((loaded / file.size) * 100).toFixed(2);
                
                const elapsedTime = (new Date() - startTime) / 1000;
                const speed = (loaded / (1024 * 1024) / elapsedTime).toFixed(2);
                
                const remainingTime = ((file.size - loaded) / (loaded / elapsedTime)).toFixed(2);
                
                updateProgressText(`Progress: ${percentComplete}% | Speed: ${speed} MB/s | Loaded: ${(loaded / (1024 * 1024)).toFixed(2)} MB | Time Left: ${remainingTime} sec`);
            }
        };

        xhr.onload = function() {
            if (xhr.status === 200) {
                currentChunk++;
                if (currentChunk < totalChunks) {
                    uploadChunk(currentChunk);
                } else {
                    updateProgressText('Upload and merge completed successfully.');
                    location.reload();
                }
            } else {
                updateProgressText(`Error uploading chunk: ${xhr.responseText}`);
            }
        };

        xhr.onerror = function() {
            updateProgressText(`Error uploading chunk`);
        };

        xhr.send(formData);
    }

    uploadChunk(currentChunk);
}

function showLoader() {
    document.getElementById('progress-overlay').style.display = 'flex';
}

function hideLoader() {
    document.getElementById('progress-overlay').style.display = 'none';
}

function updateProgressText(text) {
    document.getElementById('speed').innerText = text;
}

function submitToDatabase(game_id, ftp_archive_name, formType) {
    console.log('Game ID:', game_id);
    console.log('FTP Archive Name:', ftp_archive_name);
    
    if (!game_id || !ftp_archive_name) {
        console.error('Error: Missing required parameters.');
        alert('Error: Missing required parameters.');
        return;
    }

    var archivePath = '../uploads/game_uploads/' + ftp_archive_name;
    console.log('Archive path to be saved: ' + archivePath);

    const data = new FormData();
    data.append('game_id', game_id);
    data.append('ftp_archive_name', ftp_archive_name);

    fetch('upload_manually.php', {
        method: 'POST',
        body: data
    })
    .then(response => response.text())
    .then(responseText => {
        console.log('Response from server:', responseText);
        alert('Archive successfully submitted');
        window.location.reload();
    })
    .catch(error => {
        console.error('Error occurred:', error);
        alert('Error occurred: ' + error);
    });
}

function toggleUpdateForm(gameId) {
    var formId = 'updateForm' + gameId;
    var form = document.getElementById(formId);
    if (form.style.display === 'none') {
        form.style.removeProperty('display');
    } else {
        form.style.display = 'none';
    }
}

function confirmDelete() {
    return confirm("Are you sure you want to delete this game?");
}

// -----------------
// -----------------
// -----------------

// -----------------
// News Script Block
// -----------------
function toggleEdit(newsId) {
    const editForm = document.getElementById('editForm' + newsId);
    if (editForm.style.display === "none" || editForm.style.display === "") {
            editForm.style.display = "block";
        } else {
            editForm.style.display = "none";
        }
}
// -----------------
// -----------------
// -----------------