<?php
session_start();

require '../db_connection.php';

if (!isset($_SESSION['developer_id'])) {
    header("Location: index.php");
    exit();
}

$developer_id = $_SESSION['developer_id'];
$error_message = '';
$success_message = '';

$conn = getDBConnection();

if (isset($_GET['delete_id'])) {
    $news_id = $_GET['delete_id'];
    $stmt = $conn->prepare("DELETE FROM news WHERE id = :id AND developer_id = :developer_id");
    $stmt->bindParam(':id', $news_id);
    $stmt->bindParam(':developer_id', $developer_id);
    if ($stmt->execute()) {
        $success_message = "News deleted successfully.";
    } else {
        $error_message = "Error deleting news.";
    }
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['news_submit'])) {
        $news_title = $_POST['news_title'];
        $news_description = $_POST['news_description'];
        $news_link = $_POST['news_link'];
        $news_date = $_POST['news_date'];
        $news_image = '';

        if (isset($_FILES['news_image']) && $_FILES['news_image']['error'] === UPLOAD_ERR_OK) {
            $image_name = basename($_FILES['news_image']['name']);
            $upload_dir = '../uploads/news_images/';
            
            if (!is_dir($upload_dir)) {
                mkdir($upload_dir, 0777, true);
            }
            
            $news_image = $upload_dir . $image_name;
            
            if (!move_uploaded_file($_FILES['news_image']['tmp_name'], $news_image)) {
                $error_message = "Error uploading news image.";
            }
        }

        if (!empty($news_title) && !empty($news_description) && !empty($news_link) && !empty($news_date) && !empty($news_image)) {
            $stmt = $conn->prepare("INSERT INTO news (title, description, link, date, image, developer_id) VALUES (:title, :description, :link, :date, :image, :developer_id)");
            $stmt->bindParam(':title', $news_title);
            $stmt->bindParam(':description', $news_description);
            $stmt->bindParam(':link', $news_link);
            $stmt->bindParam(':date', $news_date);
            $stmt->bindParam(':image', $news_image);
            $stmt->bindParam(':developer_id', $developer_id);

            if ($stmt->execute()) {
                $success_message = "News added successfully.";
            } else {
                $error_message = "Error adding news to database.";
            }
        } else {
            $error_message = "Fill in all fields to add the news.";
        }
    }

    if (isset($_POST['edit_submit'])) {
        $news_id = $_POST['news_id'];
        $news_title = $_POST['news_title'];
        $news_description = $_POST['news_description'];
        $news_link = $_POST['news_link'];
        $news_date = $_POST['news_date'];
        $news_image = $_POST['existing_image'];

        if (isset($_FILES['news_image']) && $_FILES['news_image']['error'] === UPLOAD_ERR_OK) {
            $image_name = basename($_FILES['news_image']['name']);
            $news_image = '../uploads/news_images/' . $image_name;

            if (!move_uploaded_file($_FILES['news_image']['tmp_name'], $news_image)) {
                $error_message = "Error uploading news image.";
            }
        }

        $stmt = $conn->prepare("UPDATE news SET title = :title, description = :description, link = :link, date = :date, image = :image WHERE id = :id AND developer_id = :developer_id");
        $stmt->bindParam(':title', $news_title);
        $stmt->bindParam(':description', $news_description);
        $stmt->bindParam(':link', $news_link);
        $stmt->bindParam(':date', $news_date);
        $stmt->bindParam(':image', $news_image);
        $stmt->bindParam(':id', $news_id);
        $stmt->bindParam(':developer_id', $developer_id);

        if ($stmt->execute()) {
            $success_message = "News updated successfully.";
        } else {
            $error_message = "Error updating news.";
        }
    }
}

$stmt = $conn->prepare("SELECT * FROM news WHERE developer_id = :developer_id");
$stmt->bindParam(':developer_id', $developer_id);
$stmt->execute();
$news_items = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Developer Console - Manage News</title>
    <link rel="shortcut icon" href="https://aisencorporation.com/icons/ais_corp.png" type="image/x-icon">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="styles/dashboard.css">
    <script src="main.js"></script>
</head>
<body>
    <div class="container">
        <?php if ($error_message): ?>
            <div class="message error">
                <span class="close-button">&times;</span>
                <?php echo $error_message; ?>
            </div>
        <?php endif; ?>
        <?php if ($success_message): ?>
            <div class="message success">
                <span class="close-button">&times;</span>
                <?php echo $success_message; ?>
            </div>
        <?php endif; ?>
    
        <button class="button" onclick="window.location.href = 'dashboard.php'" style="float: left;">
            <div class="button-box">
                <span class="button-elem">
                <svg viewBox="0 0 46 40" xmlns="http://www.w3.org/2000/svg">
                    <path
                    d="M46 20.038c0-.7-.3-1.5-.8-2.1l-16-17c-1.1-1-3.2-1.4-4.4-.3-1.2 1.1-1.2 3.3 0 4.4l11.3 11.9H3c-1.7 0-3 1.3-3 3s1.3 3 3 3h33.1l-11.3 11.9c-1 1-1.2 3.3 0 4.4 1.2 1.1 3.3.8 4.4-.3l16-17c.5-.5.8-1.1.8-1.9z"
                    ></path>
                </svg>
                </span>
                <span class="button-elem">
                <svg viewBox="0 0 46 40">
                    <path
                    d="M46 20.038c0-.7-.3-1.5-.8-2.1l-16-17c-1.1-1-3.2-1.4-4.4-.3-1.2 1.1-1.2 3.3 0 4.4l11.3 11.9H3c-1.7 0-3 1.3-3 3s1.3 3 3 3h33.1l-11.3 11.9c-1 1-1.2 3.3 0 4.4 1.2 1.1 3.3.8 4.4-.3l16-17c.5-.5.8-1.1.8-1.9z"
                    ></path>
                </svg>
                </span>
            </div>
        </button><br>

        <br><h1>Add News</h1>

        <form action="" method="post" enctype="multipart/form-data">
            <label for="news_title">News Title:</label>
            <input type="text" id="news_title" name="news_title" required>
            
            <label for="news_description">News Description:</label>
            <textarea id="news_description" name="news_description" required></textarea>
            
            <label for="news_link">News Link:</label>
            <input type="text" id="news_link" name="news_link" required>
            
            <label for="news_date">Date:</label>
            <input type="date" id="news_date" name="news_date" required>
            
            <label for="news_image">News Image:</label>
            <input type="file" id="news_image" name="news_image" accept="image/*" required>
            
            <button type="submit" name="news_submit" class="upload-game" style="margin-top: 10px;">Add News</button>
        </form>

        <h2>Manage News</h2>
        <table>
            <thead>
                <tr>
                    <th>Title</th>
                    <th>Description</th>
                    <th>Link</th>
                    <th>Date</th>
                    <th>Image</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($news_items as $news): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($news['title']); ?></td>
                        <td><?php echo htmlspecialchars($news['description']); ?></td>
                        <td><a href="<?php echo htmlspecialchars($news['link']); ?>" target="_blank">Link</a></td>
                        <td><?php echo htmlspecialchars($news['date']); ?></td>
                        <td><img src="<?php echo htmlspecialchars($news['image']); ?>" alt="News Image" style="width: 100px;"></td>
                        <td>
                            <a href="?delete_id=<?php echo $news['id']; ?>" onclick="return confirm('Are you sure you want to delete this news?');">Delete</a>
                            <a href="javascript:void(0);" onclick="toggleEdit(<?php echo $news['id']; ?>)">Edit</a>
                        </td>
                    </tr>

                    <div id="editForm<?php echo $news['id']; ?>" class="edit-form" style="display: none;">
                        <h2>Edit News</h2>
                        <form action="" method="post" enctype="multipart/form-data">
                            <input type="hidden" name="news_id" value="<?php echo $news['id']; ?>">
                            <input type="hidden" name="existing_image" value="<?php echo htmlspecialchars($news['image']); ?>">
                            <label for="news_title">News Title:</label>
                            <input type="text" name="news_title" value="<?php echo htmlspecialchars($news['title']); ?>" required>
                            
                            <label for="news_description">News Description:</label>
                            <textarea name="news_description" required><?php echo htmlspecialchars($news['description']); ?></textarea>
                            
                            <label for="news_link">News Link:</label>
                            <input type="text" name="news_link" value="<?php echo htmlspecialchars($news['link']); ?>" required>
                            
                            <label for="news_date">Date:</label>
                            <input type="date" name="news_date" value="<?php echo htmlspecialchars($news['date']); ?>" required>
                            
                            <label for="news_image">News Image:</label>
                            <input type="file" name="news_image" accept="image/*">
                            
                            <button type="submit" name="edit_submit" class="upload-game" style="margin-top: 10px; width: 100%;">Update News</button>
                        </form>
                    </div>

                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</body>
</html>