<?php
session_start();
require '../db_connection.php';

$error_message = '';
$success_message = '';

if (isset($_GET['token']) && isset($_SESSION['reset_token']) && $_GET['token'] === $_SESSION['reset_token']) {
    $developer_id = $_SESSION['developer_id'];

    if (isset($_POST['reset_password'])) {
        $new_password = $_POST['new_password'];
        $confirm_password = $_POST['confirm_password'];

        if ($new_password === $confirm_password) {
            $hashed_password = password_hash($new_password, PASSWORD_BCRYPT);

            $conn = getDBConnection();

            try {
                $stmt = $conn->prepare("UPDATE developers SET password = :password WHERE id = :id");
                $stmt->bindParam(':password', $hashed_password, PDO::PARAM_STR);
                $stmt->bindParam(':id', $developer_id, PDO::PARAM_INT);
                $stmt->execute();

                $success_message = 'Password successfully reset. You can now <a href="index.php">login</a>.';
                unset($_SESSION['reset_token']);
                unset($_SESSION['developer_id']);
            } catch (PDOException $e) {
                $error_message = 'Database Error: ' . $e->getMessage();
            }
        } else {
            $error_message = 'Passwords do not match.';
        }
    }
} else {
    $error_message = 'Invalid or expired reset token.';
}
?>

<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reset Password</title>
    <link rel="stylesheet" href="styles/index.css">
</head>
<body>
    <div class="container">
        <h2>Reset Password</h2>
        <?php if ($error_message): ?>
            <div class="message"><?php echo $error_message; ?></div>
        <?php endif; ?>

        <?php if ($success_message): ?>
            <div class="message success"><?php echo $success_message; ?></div>
        <?php else: ?>
            <form id="reset-password-form" method="POST" action="">
                <input type="password" name="new_password" placeholder="New Password" required>
                <input type="password" name="confirm_password" placeholder="Confirm Password" required>
                <input type="submit" name="reset_password" value="Reset Password">
            </form>
        <?php endif; ?>
    </div>
</body>
</html>