<?php
require '../db_connection.php';

function sendJsonResponse($success, $message) {
    header('Content-Type: application/json');
    echo json_encode(['success' => $success, 'message' => $message]);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $verificationCode = isset($_POST['verificationCode']) ? $_POST['verificationCode'] : null;
    $newPassword = isset($_POST['newPassword']) ? $_POST['newPassword'] : null;

    if (!$verificationCode || !$newPassword) {
        sendJsonResponse(false, 'Missing verification code or new password.');
    }

    try {
        $pdo = getDBConnection();

        $stmt = $pdo->prepare('SELECT * FROM users WHERE verification_code = :verificationCode');
        $stmt->bindParam(':verificationCode', $verificationCode);
        $stmt->execute();

        if ($stmt->rowCount() > 0) {
            $user = $stmt->fetch(PDO::FETCH_ASSOC);

            $hashedPassword = password_hash($newPassword, PASSWORD_DEFAULT);

            $updateStmt = $pdo->prepare('UPDATE users SET password = :password, verification_code = NULL WHERE verification_code = :verificationCode');
            $updateStmt->bindParam(':password', $hashedPassword);
            $updateStmt->bindParam(':verificationCode', $verificationCode);
            if ($updateStmt->execute()) {
                sendJsonResponse(true, 'Password has been updated successfully.');
            } else {
                sendJsonResponse(false, 'Failed to update password.');
            }
        } else {
            sendJsonResponse(false, 'Invalid verification code.');
        }
    } catch (Exception $e) {
        error_log($e->getMessage());
        sendJsonResponse(false, 'Server error: ' . $e->getMessage());
    }
} else {
    sendJsonResponse(false, 'Invalid request method.');
}
?>