<?php
require '../db_connection.php';

function sendJsonResponse($success, $message) {
    header('Content-Type: application/json');
    echo json_encode(['success' => $success, 'message' => $message]);
    exit();
}

if (!isset($_POST['currentUserName']) || !isset($_POST['newUserName'])) {
    sendJsonResponse(false, 'Missing required parameters.');
}

$currentUserName = $_POST['currentUserName'];
$newUserName = $_POST['newUserName'];

if (empty($newUserName) || !preg_match('/^[a-zA-Z0-9_]{3,20}$/', $newUserName)) {
    sendJsonResponse(false, 'Invalid username format. Username must be 3-20 characters long and contain only letters, numbers, and underscores.');
}

if ($currentUserName === $newUserName) {
    sendJsonResponse(false, 'New username cannot be the same as the current username.');
}

try {
    $conn = getDBConnection();

    $stmt = $conn->prepare('SELECT COUNT(*) FROM users WHERE username = :newUserName');
    $stmt->bindParam(':newUserName', $newUserName, PDO::PARAM_STR);
    $stmt->execute();
    $usernameExists = $stmt->fetchColumn();

    if ($usernameExists) {
        sendJsonResponse(false, 'Username already taken.');
    }

    $stmt = $conn->prepare('UPDATE users SET username = :newUserName WHERE username = :currentUserName');
    $stmt->bindParam(':newUserName', $newUserName, PDO::PARAM_STR);
    $stmt->bindParam(':currentUserName', $currentUserName, PDO::PARAM_STR);

    if ($stmt->execute()) {
        sendJsonResponse(true, 'Username updated successfully.');
    } else {
        sendJsonResponse(false, 'Failed to update username.');
    }
} catch (PDOException $e) {
    sendJsonResponse(false, 'Database error: ' . $e->getMessage());
}
?>