<?php
require '../db_connection.php';

function sendVerificationCode($toEmail, $verificationCode) {
    $subject = "Password Reset Verification Code";
    $message = "
    <html lang='en'>
    <head>
        <meta charset='UTF-8'>
        <title>Password Reset Verification Code</title>
        <link href='https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap' rel='stylesheet'>
    </head>
    <body style='width: 100%; max-width: 600px; margin: 0 auto; padding: 0; display: flex; justify-content: center; align-items: center; background-color: #e3e3e3; color: #800080; font: 13px Roboto, serif; line-height: 25px; -webkit-text-size-adjust: none;'>
        <table cellpadding='0' border='0' cellspacing='0' style='margin: 20px auto; padding: 40px 20px; width: 100%; max-width: 600px; border-radius: 6px; text-align: center;'>
            <tr>
                <td colspan='2' style='padding-bottom: 20px;'>
                    <img src='https://drive.google.com/uc?id=16kOxTUBeHjYSyoJYL7AzXJyGU7UqtXPg' alt='Logo' style='width: 100px; height: 100px;'>
                </td>
            </tr>
            <tr>
                <td colspan='2' style='padding-bottom: 20px;'>
                    <h2 style='color: #333333; margin: 0; font-size: 28px; font-weight: 700;'>PASSWORD RESET VERIFICATION CODE</h2>
                    <hr style='background-color: black; height: 2px; border: none;'>
                </td>
            </tr>
            <tr>
                <td colspan='2' style='padding-bottom: 20px; margin: 0 auto;'>
                    <div style='width: 250px; height: 250px; margin: 0 auto;'>
                        <img src='https://drive.google.com/uc?id=1S6DO2inSiZFv1nxoXKH1LY9j73NOnsPT' alt='Email Logo' style='width: 100%; height: 100%;'>
                    </div>
                </td>
            </tr>
            <tr>
                <td colspan='2' style='padding: 20px 0;'>
                    <strong style='font-size: 36px; color: #3490EC; border: 2px dashed #3490EC; padding: 20px 40px; border-radius: 60px;'>$verificationCode</strong>
                </td>
            </tr>
            <tr>
                <td colspan='2' style='padding-bottom: 20px; margin: 0 auto;'>
                    <p style='font-size: 20px; margin-bottom: 80px; margin-top: 50px;'>DO NOT SHARE THIS CODE WITH ANYONE! <br> The verification code for password reset</p>
                </td>            
            </tr>
            <tr>
                <td colspan='2' style='font-size: 14px; color: #333333;'>
                    AisenCorporation © 2022-2025<br>
                    <strong>Password reset verification code</strong>
                    <br>AILauncher
                </td>
            </tr>
        </table>
    </body>
    </html>";    

    $headers = [
        'MIME-Version: 1.0',
        'Content-type: text/html; charset=utf-8',
        'From: no-reply@aisencorporation.com'
    ];

    return mail($toEmail, $subject, $message, implode("\r\n", $headers));
}

function generateVerificationCode($length = 6) {
    $characters = '0123456789';
    $verificationCode = '';
    for ($i = 0; $i < $length; $i++) {
        $verificationCode .= $characters[rand(0, strlen($characters) - 1)];
    }
    return $verificationCode;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $usernameOrEmail = $_POST['usernameOrEmail'];

    $pdo = getDBConnection();

    $stmt = $pdo->prepare('SELECT * FROM users WHERE username = :usernameOrEmail OR email = :usernameOrEmail');
    $stmt->bindParam(':usernameOrEmail', $usernameOrEmail);
    $stmt->execute();

    if ($stmt->rowCount() > 0) {
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        $verificationCode = generateVerificationCode();

        $updateStmt = $pdo->prepare('UPDATE users SET verification_code = :verificationCode WHERE id = :userId');
        $updateStmt->bindParam(':verificationCode', $verificationCode);
        $updateStmt->bindParam(':userId', $user['id']);
        $updateStmt->execute();

        if (sendVerificationCode($user['email'], $verificationCode)) {
            echo json_encode(['success' => true, 'message' => 'Verification code has been sent to your email.', 'verificationCode' => $verificationCode]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to send verification code. Please try again later.']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'No user found with that username or email.']);
    }
}
?>