<?php
require '../db_connection.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'];
    $uploadDirectory = '../uploads/game_avatars';
    if (!is_dir($uploadDirectory)) {
        if (!mkdir($uploadDirectory, 0755, true)) {
            die('Failed to create upload directory: ' . $uploadDirectory);
        }
    }

    if ($_FILES['avatar']['error'] === UPLOAD_ERR_OK) {
        $fileName = uniqid('avatar_') . '_' . basename($_FILES['avatar']['name']);
        $uploadPath = $uploadDirectory . $fileName;

        if (move_uploaded_file($_FILES['avatar']['tmp_name'], $uploadPath)) {
            $pdo = getDBConnection();

            $stmt = $pdo->prepare('UPDATE users SET avatar = :avatar WHERE username = :username');
            $stmt->bindParam(':avatar', $uploadPath);
            $stmt->bindParam(':username', $username);

            if ($stmt->execute()) {
                echo json_encode(['success' => true, 'message' => 'Avatar uploaded successfully', 'avatarPath' => $uploadPath]);
            } else {
                echo json_encode(['success' => false, 'message' => 'Failed to update avatar.']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to move uploaded file.']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Error uploading file.']);
    }
}
?>