<?php 
require 'db_connection.php';

$current_version = $_GET['version'];

$conn = getDBConnection();

$sql = "SELECT * FROM app_updates ORDER BY upload_date DESC LIMIT 1";
$stmt = $conn->prepare($sql);
$stmt->execute();
$result = $stmt->fetch(PDO::FETCH_ASSOC);

if ($result) {
    $latest_version = $result['version'];
    $installer_url = $result['installer_url'];
    $release_notes = $result['release_notes'] ?? '';

    if (version_compare($current_version, $latest_version, '<')) {
        echo json_encode([
            'update_available' => true,
            'latest_version' => $latest_version,
            'installer_url' => $installer_url,
            'release_notes' => $release_notes
        ]);
    } else {
        echo json_encode(['update_available' => false]);
    }
} else {
    echo json_encode(['update_available' => false, 'error' => 'No updates found']);
}

$conn = null;
?>