<?php
require 'db_connection.php';

function tableExists($conn, $tableName) {
    $result = $conn->query("SHOW TABLES LIKE '$tableName'");
    return $result && $result->num_rows > 0;
}

$sql = file_get_contents('tables.sql');
if ($sql === false) {
    die('Error reading tables.sql');
}

$sqlStatements = explode(';', $sql);

$tablesCreated = false;

foreach ($sqlStatements as $statement) {
    $statement = trim($statement);
    if ($statement) {
        if (stripos($statement, 'CREATE TABLE') !== false) {
            preg_match('/CREATE TABLE `?(\w+)`?/i', $statement, $matches);
            if (isset($matches[1])) {
                $tableName = $matches[1];
                if (!tableExists($conn, $tableName)) {
                    if ($conn->query($statement) === false) {
                        die('Error executing query: ' . $conn->error);
                    }
                    $tablesCreated = true;
                }
            }
        } else {
            if ($conn->query($statement) === false) {
                die('Error executing query: ' . $conn->error);
            }
        }
    }
}

if ($tablesCreated) {
    echo 'Tables created successfully';
} else {
    echo 'Tables already exist or no tables to create';
}
?>