<?php
require '../db_connection.php';

header('Content-Type: application/json');

try {
    $pdo = getDBConnection();
    $query = "
        SELECT 
            games.id, 
            games.title, 
            games.description, 
            games.game_avatar,
            games.game_banner,
            developers.id AS developer_id, 
            developers.companyname AS developer_name, 
            developers.avatar AS developer_avatar,
            games.version,
            games.isEditorChoice,
            games.upload_date,
            games.tags,
            games.rating,
            CASE 
                WHEN game_of_the_day.end_date IS NOT NULL THEN 1 
                ELSE 0 
            END AS is_game_of_the_day,
            (
                SELECT 
                    game_of_the_day.end_date 
                FROM 
                    game_of_the_day 
                WHERE 
                    game_of_the_day.game_id = games.id 
                    AND game_of_the_day.end_date > NOW() 
                ORDER BY 
                    game_of_the_day.end_date DESC
                LIMIT 1
            ) AS game_of_the_day_end_date
        FROM 
            games 
        INNER JOIN 
            developers 
        ON 
            games.developer_id = developers.id
        LEFT JOIN 
            game_of_the_day 
        ON 
            games.id = game_of_the_day.game_id
    ";

    $stmt = $pdo->query($query);
    $games = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode($games);
} catch (PDOException $e) {
    echo json_encode(['error' => 'Error: ' . $e->getMessage()]);
}
?>