<?php 
require '../db_connection.php'; 
 
header('Content-Type: application/json'); 
 
try { 
    $conn = getDBConnection(); 
 
    $query = "SELECT is_active, end_time FROM maintenance LIMIT 1"; 
    $stmt = $conn->prepare($query); 
    $stmt->execute(); 
    $maintenance = $stmt->fetch(PDO::FETCH_ASSOC); 
 
    if ($maintenance) { 
        $response = [ 
            'is_active' => (bool)$maintenance['is_active'], 
            'end_time' => $maintenance['end_time'] ?? null, 
        ]; 
    } else { 
        $response = [ 
            'is_active' => false, 
            'end_time' => null, 
        ]; 
    } 
 
    echo json_encode($response, JSON_THROW_ON_ERROR); 
} catch (Exception $e) { 
    http_response_code(500); 
    echo json_encode(['error' => $e->getMessage()], JSON_THROW_ON_ERROR); 
} 
?>