<?php
require '../db_connection.php';

try {
    $db = getDBConnection();

    if (isset($_POST['username']) && !empty($_POST['username'])) {
        $username = $_POST['username'];

        $query = "SELECT id, username, library FROM users WHERE username = :username";
        $stmt = $db->prepare($query);
        $stmt->bindParam(':username', $username);
        $stmt->execute();

        if ($stmt->rowCount() > 0) {
            $user = $stmt->fetch(PDO::FETCH_ASSOC);
            $response['success'] = true;
            $response['username'] = $user['username'];

            $libraryArray = json_decode($user['library'], true);

            if (!empty($libraryArray)) {
                $libraryArray = array_unique($libraryArray);
                $placeholders = implode(',', array_fill(0, count($libraryArray), '?'));
                
                $query = "
                    SELECT 
                        games.id, 
                        games.title, 
                        games.description, 
                        games.game_avatar, 
                        games.game_banner,
                        developers.id AS developer_id, 
                        developers.companyname AS developer_name, 
                        developers.avatar AS developer_avatar,
                        games.version,
                        games.isEditorChoice,
                        games.upload_date,
                        games.tags,
                        games.rating
                    FROM games
                    LEFT JOIN developers ON games.developer_id = developers.id
                    WHERE games.id IN ($placeholders)
                ";
                $stmt = $db->prepare($query);
                $stmt->execute($libraryArray);

                $games = $stmt->fetchAll(PDO::FETCH_ASSOC);
                $response['games'] = $games;
            } else {
                $response['games'] = [];
            }
        } else {
            $response['success'] = false;
            $response['message'] = 'User not found';
        }
    } else {
        $response['success'] = true;
        $response['games'] = [];
    }
} catch (PDOException $e) {
    $response['success'] = false;
    $response['message'] = "Database error: " . $e->getMessage();
}

echo json_encode($response);
?>