<?php
require '../db_connection.php';

header('Content-Type: application/json');

if (!isset($_GET['game_id'], $_GET['username'])) {
    echo json_encode(['error' => 'Missing required parameters']);
    exit;
}

$gameId = $_GET['game_id'];
$username = $_GET['username'];

try {
    $pdo = getDBConnection();

    $checkQuery = "SELECT id FROM reviews WHERE game_id = :game_id AND username = :username";
    $stmt = $pdo->prepare($checkQuery);
    $stmt->execute([':game_id' => $gameId, ':username' => $username]);
    $reviewExists = $stmt->fetchColumn();

    if ($reviewExists) {
        echo json_encode(['review_exists' => true]);
    } else {
        echo json_encode(['review_exists' => false]);
    }
} catch (PDOException $e) {
    echo json_encode(['error' => 'Error: ' . $e->getMessage()]);
}
?>