<?php
session_start();
require '../db_connection.php';

$tempDir = '../uploads/game_uploads/temp/';

if (!is_dir($tempDir)) {
    mkdir($tempDir, 0777, true);
}

$response = ['status' => 'error', 'message' => 'Invalid request'];

if (isset($_POST['chunk_number']) && isset($_POST['total_chunks']) && isset($_FILES['chunk']) && isset($_POST['game_id'])) {
    $chunkNumber = (int)$_POST['chunk_number'];
    $totalChunks = (int)$_POST['total_chunks'];
    $gameId = $_POST['game_id'];
    $chunk = $_FILES['chunk'];

    if ($chunk['error'] === UPLOAD_ERR_OK) {
        $chunkPath = $tempDir . $gameId . '.part' . $chunkNumber;

        if (move_uploaded_file($chunk['tmp_name'], $chunkPath)) {
            if ($chunkNumber === $totalChunks - 1) {
                $response = mergeChunksIntoZip($gameId, $totalChunks, $tempDir);
            } else {
                $response = ['status' => 'success', 'message' => 'Chunk uploaded successfully'];
            }
        } else {
            $response = ['status' => 'error', 'message' => 'Error moving uploaded chunk'];
        }
    } else {
        $response = ['status' => 'error', 'message' => 'Error uploading chunk'];
    }
}

header('Content-Type: application/json');
echo json_encode($response);

function mergeChunksIntoZip($gameId, $totalChunks, $tempDir) {
    $executablePath = '../uploads/game_uploads/' . $gameId . '.zip';
    $outputFile = fopen($executablePath, 'wb');

    if ($outputFile) {
        for ($i = 0; $i < $totalChunks; $i++) {
            $partPath = $tempDir . $gameId . '.part' . $i;

            if (!file_exists($partPath)) {
                return ['status' => 'error', 'message' => 'Missing parts'];
            }

            $partFile = fopen($partPath, 'rb');
            while ($data = fread($partFile, 8192)) {
                fwrite($outputFile, $data);
            }
            fclose($partFile);
            unlink($partPath);
        }

        fclose($outputFile);

        $conn = getDBConnection();
        $update_stmt = $conn->prepare("UPDATE games SET executable_file = :executable_file WHERE id = :game_id");
        $update_stmt->bindParam(':executable_file', $executablePath, PDO::PARAM_STR);
        $update_stmt->bindParam(':game_id', $gameId, PDO::PARAM_INT);
        $update_stmt->execute();

        return ['status' => 'completed', 'message' => 'File uploaded and merged successfully'];
    } else {
        return ['status' => 'error', 'message' => 'Failed to create output file'];
    }
}
?>