<?php
session_start();
require '../db_connection.php';

$conn = getDBConnection();

$gameId = isset($_POST['game_id']) ? $_POST['game_id'] : null;
$ftpArchiveName = isset($_POST['ftp_archive_name']) ? $_POST['ftp_archive_name'] : null;

if ($gameId && $ftpArchiveName) {
    $executablePath = '../uploads/game_uploads/' . $ftpArchiveName;

    try {
        $check_stmt = $conn->prepare("SELECT executable_file FROM games WHERE id = :game_id");
        $check_stmt->bindParam(':game_id', $gameId, PDO::PARAM_INT);
        $check_stmt->execute();

        $currentExecutablePath = $check_stmt->fetchColumn();

        if ($currentExecutablePath === null || $currentExecutablePath === '') {
            $update_stmt = $conn->prepare("UPDATE games SET executable_file = :executable_file WHERE id = :game_id");
            $update_stmt->bindParam(':executable_file', $executablePath, PDO::PARAM_STR);
            $update_stmt->bindParam(':game_id', $gameId, PDO::PARAM_INT);

            if ($update_stmt->execute()) {
                echo "The executable file path has been updated successfully!";
            } else {
                echo "Error: Could not update the executable file path.";
            }
        } else {
            echo "Executable file already set for this game: " . $currentExecutablePath;
        }
    } catch (PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
} else {
    echo "Error: Missing required parameters.";
}
?>