<?php
session_start();
require '../db_connection.php';

$avatarDir = '../uploads/game_avatars/';
$screenshotsDir = '../uploads/game_screenshots/';
$bannerDir = '../uploads/game_banners/';
$exeDir = '../uploads/game_executables/';

if (!is_dir($avatarDir)) mkdir($avatarDir, 0777, true);
if (!is_dir($screenshotsDir)) mkdir($screenshotsDir, 0777, true);
if (!is_dir($bannerDir)) mkdir($bannerDir, 0777, true);
if (!is_dir($exeDir)) mkdir($exeDir, 0777, true);

$conn = getDBConnection();

$response = ['status' => 'error', 'message' => 'Invalid request'];

if (isset($_POST['game_title']) && isset($_POST['game_version'])) {
    $gameTitle = $_POST['game_title'];
    $gameDescription = $_POST['game_description'];
    $gameVersion = $_POST['game_version'];
    $isEditorChoice = isset($_POST['is_editor_choice']) ? 1 : 0;
    $developerId = $_SESSION['developer_id'];
    $uploadDate = date("Y-m-d H:i:s");
    
    if (isset($_POST['game_tags'])) {
        $tags = $_POST['game_tags'];
        $tags = !empty($tags) ? implode(', ', array_slice(explode(',', trim($tags)), 0, 5)) : 'Games';
    } else {
        $tags = 'Games';
    }

    $avatarPath = NULL;
    if (isset($_FILES['game_avatar']) && $_FILES['game_avatar']['error'] === UPLOAD_ERR_OK) {
        $avatarFile = $_FILES['game_avatar'];
        $avatarPath = $avatarDir . basename($avatarFile['name']);
        if (!move_uploaded_file($avatarFile['tmp_name'], $avatarPath)) {
            echo json_encode(['status' => 'error', 'message' => 'Error moving avatar file.']);
            exit;
        }
    }

    $bannerPath = NULL;
    if (isset($_FILES['game_banner']) && $_FILES['game_banner']['error'] === UPLOAD_ERR_OK) {
        $bannerFile = $_FILES['game_banner'];
        $bannerPath = $bannerDir . basename($bannerFile['name']);
        if (!move_uploaded_file($bannerFile['tmp_name'], $bannerPath)) {
            echo json_encode(['status' => 'error', 'message' => 'Error moving banner file.']);
            exit;
        }
    }

    $screenshotPaths = [];
    if (isset($_FILES['game_screenshots'])) {
        $screenshotsFiles = $_FILES['game_screenshots'];
        foreach ($screenshotsFiles['tmp_name'] as $key => $tmpName) {
            if ($screenshotsFiles['error'][$key] === UPLOAD_ERR_OK) {
                $screenshotPath = $screenshotsDir . basename($screenshotsFiles['name'][$key]);
                if (!move_uploaded_file($tmpName, $screenshotPath)) {
                    echo json_encode(['status' => 'error', 'message' => 'Error moving screenshot file.']);
                    exit;
                }
                $screenshotPaths[] = $screenshotPath;
            }
        }
    }

    $insert_stmt = $conn->prepare("INSERT INTO games (title, description, version, isEditorChoice, developer_id, game_avatar, tags, upload_date, game_banner) VALUES (:title, :description, :version, :is_editor_choice, :developer_id, :game_avatar, :tags, :upload_date, :game_banner)");
    $insert_stmt->bindParam(':title', $gameTitle, PDO::PARAM_STR);
    $insert_stmt->bindParam(':description', $gameDescription, PDO::PARAM_STR);
    $insert_stmt->bindParam(':version', $gameVersion, PDO::PARAM_STR);
    $insert_stmt->bindParam(':is_editor_choice', $isEditorChoice, PDO::PARAM_INT);
    $insert_stmt->bindParam(':developer_id', $developerId, PDO::PARAM_INT);
    $insert_stmt->bindParam(':game_avatar', $avatarPath, PDO::PARAM_STR);
    $insert_stmt->bindParam(':tags', $tags, PDO::PARAM_STR);
    $insert_stmt->bindParam(':upload_date', $uploadDate, PDO::PARAM_STR);
    $insert_stmt->bindParam(':game_banner', $bannerPath, PDO::PARAM_STR);

    if ($insert_stmt->execute()) {
        $gameId = $conn->lastInsertId();

        $orientation = $_POST['screenshot_orientation'] ?? 'horizontal';

        foreach ($screenshotPaths as $screenshotPath) {
            $uploadTime = date("Y-m-d H:i:s");

            $insert_screenshot_stmt = $conn->prepare("INSERT INTO game_screenshots (game_id, screenshot_url, orientation, upload_time) VALUES (:game_id, :screenshot_url, :orientation, :upload_time)");
            $insert_screenshot_stmt->bindParam(':game_id', $gameId, PDO::PARAM_INT);
            $insert_screenshot_stmt->bindParam(':screenshot_url', $screenshotPath, PDO::PARAM_STR);
            $insert_screenshot_stmt->bindParam(':orientation', $orientation, PDO::PARAM_STR);
            $insert_screenshot_stmt->bindParam(':upload_time', $uploadTime, PDO::PARAM_STR);
            $insert_screenshot_stmt->execute();
        }

        $response = ['status' => 'success', 'game_id' => $gameId];
    } else {
        $response = ['status' => 'error', 'message' => 'Error saving game data.'];
    }
}

header('Content-Type: application/json');
echo json_encode($response);
?>