<?php
require 'db_connection.php';

if (!isset($_GET['game_id'])) {
    http_response_code(400);
    echo "Error: Game ID is required";
    exit();
}

$game_id = $_GET['game_id'];

try {
    $db = getDBConnection();
    $query = $db->prepare("SELECT executable_file FROM games WHERE id = :game_id");
    $query->bindParam(':game_id', $game_id, PDO::PARAM_INT);
    $query->execute();

    $result = $query->fetch(PDO::FETCH_ASSOC);

    if (!$result || empty($result['executable_file'])) {
        http_response_code(404);
        echo "Error: Executable file not found for the specified game ID";
        exit();
    }

    $executable_file_path = $result['executable_file'];

    $base_url = "https://" . $_SERVER['HTTP_HOST'] . "/pc_launcher/php/";

    $executable_full_url = $base_url . ltrim($executable_file_path, '../');

    $executable_full_path = $_SERVER['DOCUMENT_ROOT'] . "/pc_launcher/php/" . ltrim($executable_file_path, '../');

    if (!file_exists($executable_full_path)) {
        http_response_code(404);
        echo "Error: Executable file not found on the server";
        exit();
    }

    $file_size = filesize($executable_full_path);
    $start = 0;
    $length = $file_size;

    if (isset($_SERVER['HTTP_RANGE'])) {
        list(, $range) = explode('=', $_SERVER['HTTP_RANGE'], 2);
        $range = explode('-', $range);
        $start = (int)$range[0];
        $length = isset($range[1]) ? (int)$range[1] - $start + 1 : $file_size - $start;

        if ($start >= $file_size || $length < 0) {
            http_response_code(416);
            echo "Error: Requested Range Not Satisfiable";
            exit();
        }

        header("HTTP/1.1 206 Partial Content");
    } else {
        header("HTTP/1.1 200 OK");
    }

    header("Content-Type: application/octet-stream");
    header("Content-Disposition: attachment; filename=\"" . basename($executable_file_path) . "\"");
    header("Content-Length: $length");
    header("Accept-Ranges: bytes");
    header("Content-Range: bytes $start-" . ($start + $length - 1) . "/$file_size");
    header("Cache-Control: no-cache");
    header("Pragma: no-cache");

    ob_clean();
    flush();

    $handle = fopen($executable_full_path, "rb");
    if ($handle) {
        fseek($handle, $start);
        $buffer_size = 8192;
        while ($length > 0 && !feof($handle)) {
            $buffer = fread($handle, min($buffer_size, $length));
            if ($buffer === false) {
                break;
            }
            echo $buffer;
            flush();
            $length -= strlen($buffer);
        }
        fclose($handle);
    } else {
        http_response_code(500);
        echo "Error: Failed to open executable file for reading";
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo "Error: Database error: " . $e->getMessage();
}
?>