<?php
require 'db_connection.php';

header('Content-Type: application/json');

if (!isset($_POST['game_id'], $_POST['rating'], $_POST['review'], $_POST['username'])) {
    echo json_encode(['error' => 'Missing required parameters']);
    exit;
}

$username = $_POST['username'];
$game_id = (int) $_POST['game_id'];
$rating = (int) $_POST['rating'];
$review = trim($_POST['review']);

if ($rating < 1 || $rating > 5) {
    echo json_encode(['error' => 'Rating must be between 1 and 5']);
    exit;
}

try {
    $pdo = getDBConnection();

    $checkQuery = "SELECT id FROM reviews WHERE game_id = :game_id AND username = :username";
    $stmt = $pdo->prepare($checkQuery);
    $stmt->execute([':game_id' => $game_id, ':username' => $username]);
    $reviewExists = $stmt->fetchColumn();

    if ($reviewExists) {
        echo json_encode(['error' => 'You have already left a review for this game.']);
        exit;
    }

    $insertQuery = "INSERT INTO reviews (game_id, username, rating, review) VALUES (:game_id, :username, :rating, :review)";
    $stmt = $pdo->prepare($insertQuery);
    $stmt->execute([':game_id' => $game_id, ':username' => $username, ':rating' => $rating, ':review' => $review]);

    $aggregateQuery = "SELECT COUNT(*) as total_reviews, SUM(rating) as total_rating FROM reviews WHERE game_id = :game_id";
    $stmt = $pdo->prepare($aggregateQuery);
    $stmt->execute([':game_id' => $game_id]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    $totalReviews = $row['total_reviews'];
    $totalRating = $row['total_rating'];
    $averageRating = $totalReviews > 0 ? round($totalRating / $totalReviews, 2) : 0;

    $updateStmt = $pdo->prepare("UPDATE games SET rating = :rating WHERE id = :game_id");
    $updateStmt->execute([':rating' => $averageRating, ':game_id' => $game_id]);

    echo json_encode(['success' => 'Review added successfully.', 'average_rating' => $averageRating]);

} catch (PDOException $e) {
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
}
?>