<?php
require 'db_connection.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $gameId = $_POST['game_id'];
    $username = $_POST['username'];

    try {
        $conn = getDBConnection();

        $stmtUser = $conn->prepare("SELECT id FROM users WHERE username = ?");
        $stmtUser->bindParam(1, $username);
        $stmtUser->execute();

        if ($stmtUser->rowCount() > 0) {
            $userRow = $stmtUser->fetch(PDO::FETCH_ASSOC);
            $userId = $userRow['id'];

            $stmtLibrary = $conn->prepare("SELECT library FROM users WHERE id = ?");
            $stmtLibrary->bindParam(1, $userId);
            $stmtLibrary->execute();
            $libraryRow = $stmtLibrary->fetch(PDO::FETCH_ASSOC);
            $currentLibrary = $libraryRow['library'];

            $libraryArray = json_decode($currentLibrary, true);
            if (!is_array($libraryArray)) {
                $libraryArray = [];
            }
            if (!in_array($gameId, $libraryArray)) {
                $libraryArray[] = $gameId;
                $newLibraryJson = json_encode($libraryArray);

                $stmtUpdate = $conn->prepare("UPDATE users SET library = ? WHERE id = ?");
                $stmtUpdate->bindParam(1, $newLibraryJson);
                $stmtUpdate->bindParam(2, $userId);
                $stmtUpdate->execute();

                $response = array("success" => true, "message" => "The game has been successfully added to the user's library.");
            } else {
                $response = array("success" => true, "message" => "The game is already in the user's library.");
            }
        } else {
            $response = array("success" => false, "message" => "User with this username not found.");
        }

        header('Content-Type: application/json');
        echo json_encode($response);
    } catch (PDOException $e) {
        $response = array("success" => false, "message" => "Error: " . $e->getMessage());
        echo json_encode($response);
    }
} else {
    $response = array("success" => false, "message" => "Invalid request method.");
    echo json_encode($response);
}
?>