<?php
require '../db_connection.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $usernameOrEmail = $_POST['usernameOrEmail'];

    $pdo = getDBConnection();

    $stmt = $pdo->prepare('SELECT * FROM users WHERE email = :Email');
    $stmt->bindParam(':Email', $usernameOrEmail);
    $stmt->execute();

    if ($stmt->rowCount() > 0) {
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        $deleteStmt = $pdo->prepare('DELETE FROM users WHERE id = :id');
        $deleteStmt->bindParam(':id', $user['id']);
        $deleteStmt->execute();

        echo json_encode(['success' => true, 'message' => 'Account deleted successfully.']);
    } else {
        echo json_encode(['success' => false, 'message' => 'User not found.']);
    }
}
?>