<?php
require '../db_connection.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'];

    $pdo = getDBConnection();

    $stmt = $pdo->prepare('SELECT avatar FROM users WHERE username = :username');
    $stmt->bindParam(':username', $username);

    if ($stmt->execute()) {
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($row) {
            $avatarPath = $row['avatar'];
            echo json_encode(['success' => true, 'avatarPath' => $avatarPath]);
        } else {
            echo json_encode(['success' => false, 'message' => 'User not found.']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to fetch avatar.']);
    }
}
?>