<?php
require '../db_connection.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $usernameOrEmail = $_POST['usernameOrEmail'];
    $password = $_POST['password'];
    
    $pdo = getDBConnection();
    
    $stmt = $pdo->prepare('SELECT * FROM users WHERE username = :usernameOrEmail OR email = :usernameOrEmail');
    $stmt->bindParam(':usernameOrEmail', $usernameOrEmail);
    $stmt->execute();

    if ($stmt->rowCount() > 0) {
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if (password_verify($password, $user['password'])) {
            $userIp = $_SERVER['REMOTE_ADDR'];
            $userAgent = $_SERVER['HTTP_USER_AGENT'];

            function getDeviceInfo($userAgent) {
                if (strpos($userAgent, 'Unity') !== false) {
                    return 'Unity Engine Detected';
                }

                if (preg_match('/mobile/i', $userAgent)) {
                    // Android
                    if (preg_match('/android/i', $userAgent)) {
                        if (preg_match('/; ([^;]+) Build/i', $userAgent, $matches)) {
                            return 'Android Device, Model: ' . $matches[1];
                        }
                        return 'Android Device';
                    } 
                    // iPhone
                    elseif (preg_match('/iphone/i', $userAgent)) {
                        if (preg_match('/iPhone; CPU iPhone OS ([\d_]+) like Mac OS X/i', $userAgent, $matches)) {
                            return 'iPhone, Model: ' . $matches[1];
                        }
                        return 'iPhone';
                    } 
                    return 'Mobile Device';
                }
                
                // Windows
                if (preg_match('/windows/i', $userAgent)) {
                    if (preg_match('/Windows NT (\d+\.\d+)/', $userAgent, $matches)) {
                        return 'Windows PC, Version: ' . $matches[1];
                    }
                    return 'Windows PC';
                }

                // Mac
                if (preg_match('/mac/i', $userAgent)) {
                    return 'Mac OS';
                }

                // Linux
                if (preg_match('/linux/i', $userAgent)) {
                    return 'Linux PC';
                }

                return 'Unknown Device';
            }

            $deviceInfo = getDeviceInfo($userAgent);

            function getRegionByIP($ip) {
                $apiUrl = "https://ipinfo.io/{$ip}/json";
                $response = file_get_contents($apiUrl);
                $data = json_decode($response, true);

                return $data['region'] ?? 'Unknown Region';
            }

            $region = getRegionByIP($userIp);
            
            if ($user['last_login_ip'] !== $userIp) {
                $to = $user['email'];
                $subject = "Security Alert: New Login Detected";
                
                $message = "
                <html>
                <head>
                    <style>
                        body { font-family: Arial, sans-serif; background-color: #000000; color: #FFFFFF; padding: 20px; }
                        .container { background-color: #1A1A1A; border-radius: 8px; padding: 20px; max-width: 600px; margin: 0 auto; }
                        .header { font-size: 24px; color: #FFD700; text-align: center; margin-bottom: 20px; }
                        .content { font-size: 16px; line-height: 1.6; color: #FFFFFF; }
                        .highlight { color: #FFD700; font-weight: bold; }
                        .footer { font-size: 14px; color: #999999; text-align: center; margin-top: 20px; }
                    </style>
                </head>
                <body>
                    <div class='container'>
                        <div class='header'>Security Alert: New Login Detected</div>
                        <div class='content'>
                            Hello <span class='highlight'>{$user['username']}</span>,<br><br>
                            A new login to your account was detected from the IP address: <span class='highlight'>{$userIp}</span>
                            using the following device:<br><br>
                            <span class='highlight'>{$deviceInfo}</span><br><br>
                            The login was detected from the region: <span class='highlight'>{$region}</span>.<br><br>
                            
                            If this was not you, please <span class='highlight'>change your password immediately</span> to secure your account.<br><br>
                            
                            Regards,<br>
                            Your <span class='highlight'>PC Launcher</span> Team
                        </div>
                        <div class='footer'>
                            This is an automated message. Please do not reply.
                        </div>
                    </div>
                </body>
                </html>
                ";
                
                $headers = "MIME-Version: 1.0" . "\r\n";
                $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
                $headers .= "From: no-reply@aisencorporation.com" . "\r\n" .
                            "Reply-To: help@aisencorporation.com" . "\r\n";

                mail($to, $subject, $message, $headers);

                $updateStmt = $pdo->prepare('UPDATE users SET last_login_ip = :userIp WHERE id = :userId');
                $updateStmt->bindParam(':userIp', $userIp);
                $updateStmt->bindParam(':userId', $user['id']);
                $updateStmt->execute();
            }

            echo json_encode([
                'success' => true,
                'message' => 'Login successful.',
                'username' => $user['username'],
                'email' => $user['email']
            ]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Incorrect password.']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'User not found.']);
    }
}
?>