<?php
require '../db_connection.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'];
    $email = $_POST['email'];
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);

    $pdo = getDBConnection();

    $stmt = $pdo->prepare('SELECT * FROM users WHERE username = :username OR email = :email');
    $stmt->bindParam(':username', $username);
    $stmt->bindParam(':email', $email);
    $stmt->execute();

    if ($stmt->rowCount() > 0) {
        $existingUser = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($existingUser['username'] === $username) {
            echo json_encode(['success' => false, 'message' => 'Username is already taken.']);
        } elseif ($existingUser['email'] === $email) {
            echo json_encode(['success' => false, 'message' => 'Email is already registered.']);
        }
    } else {
        $stmt = $pdo->prepare('INSERT INTO users (username, email, password) VALUES (:username, :email, :password)');
        $stmt->bindParam(':username', $username);
        $stmt->bindParam(':email', $email);
        $stmt->bindParam(':password', $password);

        if ($stmt->execute()) {
            $to = $email;
            $subject = 'Welcome to PC Launcher!';
            $message = '
            <html>
            <head>
                <title>Welcome to PC Launcher!</title>
            </head>
            <body style="font-family: Arial, sans-serif; background-color: #f4f4f4; padding: 20px;">
                <div style="max-width: 600px; margin: auto; background-color: #ffffff; padding: 20px; border-radius: 10px; box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);">
                    <h1 style="color: #333; font-size: 24px; font-weight: bold; text-align: center; margin-bottom: 20px;">
                        Welcome, ' . htmlspecialchars($username) . '!
                    </h1>
                    <p style="font-size: 16px; color: #333; line-height: 1.5; margin-bottom: 20px;">
                        Thank you for registering with PC Launcher. You can now access all of our features and enjoy the service.
                    </p>
                    <p style="font-size: 16px; color: #333; font-weight: bold; margin-bottom: 10px;">
                        Your login details:
                    </p>
                    <ul style="list-style-type: none; padding: 0; font-size: 16px; color: #333; margin-bottom: 20px;">
                        <li style="margin-bottom: 5px;"><strong>Username:</strong> ' . htmlspecialchars($username) . '</li>
                        <li style="margin-bottom: 5px;"><strong>Email:</strong> ' . htmlspecialchars($email) . '</li>
                    </ul>
                    <p style="font-size: 16px; color: #333; line-height: 1.5; margin-bottom: 20px;">
                        We are glad to have you on board!
                    </p>
                    <p style="font-size: 16px; color: #333; line-height: 1.5;">
                        Best regards,<br>The PC Launcher Team
                    </p>
                </div>
            </body>
            </html>';            

            $headers = "MIME-Version: 1.0" . "\r\n";
            $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
            $headers .= 'From: no-reply@aisencorporation.com' . "\r\n";

            if (mail($to, $subject, $message, $headers)) {
                echo json_encode(['success' => true, 'message' => 'Account created successfully. A welcome email has been sent.']);
            } else {
                echo json_encode(['success' => true, 'message' => 'Account created successfully, but failed to send welcome email.']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to create account.']);
        }
    }
}
?>